<?php
/**
 * ZForex Trading Platform - Main Configuration File
 * Includes database connection, mail system, and all application settings
 */

// ================================
// DATABASE CONFIGURATION
// ================================
define("DB_HOST", "localhost");
define("DB_USER", "root");
define("DB_PASS", "");
define("DB_NAME", "crmcentrioglobal_ecotradefx");

// ================================
// MAIL SYSTEM CONFIGURATION
// ================================
define('MAIL_HOST', 'send.smtp.com');
define('MAIL_PORT', 465);
define("MAIL_USERNAME", "support@mykfmarkets.com"); // Support email address
define("MAIL_PASSWORD", "support@mykfmarkets.com"); 
define('MAIL_ENCRYPTION', 'ssl');
define('MAIL_FROM_EMAIL', 'support@mykfmarkets.com');
define('MAIL_FROM_NAME', 'MyKFMarkets');

// ================================
// EMAIL TEMPLATE SETTINGS
// ================================
define('EMAIL_AUTOMATION_ENABLED', true);
define('LOG_PATH', __DIR__ . '/logs/');
define('COMPANY_NAME', 'EcoTradeFX');
define('COMPANY_WEBSITE', 'https://ecotradefx.com');
define('SUPPORT_EMAIL', 'support@ecotradefx.com');
define('COMPANY_ADDRESS', 'Your Company Address');

// ================================
// APPLICATION SETTINGS
// ================================
define('APP_NAME', 'EcoTradeFX');
define('APP_URL', 'https://ecotradefx.com');
define('APP_ENVIRONMENT', 'development'); // development, staging, production

// ================================
// MT5 API CONFIGURATION
// ================================
define('MT5_SERVER_IP', '127.0.0.1');
define('MT5_SERVER_PORT', 443);
define('MT5_TIMEOUT', 5);
define('MT5_SERVER_WEB_LOGIN', 'your_mt5_login');
define('MT5_SERVER_WEB_PASSWORD', 'your_mt5_password');

// ================================
// DATABASE CONNECTION (PDO)
// ================================
// Use PDO instead of mysqli (mysqli extension not available)
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // For backward compatibility, create a mysqli-like connection object
    $conn = new stdClass();
    $conn->pdo = $pdo;
    $conn->connect_error = false;
    
    // Add helper methods for mysqli compatibility
    $conn->query = function($sql) use ($pdo) {
        return $pdo->query($sql);
    };
    
    $conn->prepare = function($sql) use ($pdo) {
        return $pdo->prepare($sql);
    };
    
    $conn->real_escape_string = function($string) use ($pdo) {
        return $pdo->quote($string);
    };
    
    $conn->close = function() use ($pdo) {
        $pdo = null;
    };
    
} catch(PDOException $e) {
    die("❌ Database connection failed: " . $e->getMessage());
}

// ================================
// MAIL SYSTEM INTEGRATION
// ================================
// Include the integrated mail system
if (file_exists(__DIR__ . '/mail_system/integrated_mail_system.php')) {
    require_once __DIR__ . '/mail_system/integrated_mail_system.php';
    
    // Initialize mail system for global use
    $mailSystem = getMailSystem();
    
    // Make mail functions globally available
    if (!function_exists('sendWelcomeEmail')) {
        function sendWelcomeEmail($to, $name, $loginUrl = '') {
            global $mailSystem;
            return $mailSystem->sendWelcomeEmail($to, $name, $loginUrl);
        }
    }
    
    if (!function_exists('sendPasswordResetEmail')) {
        function sendPasswordResetEmail($to, $name, $resetLink) {
            global $mailSystem;
            return $mailSystem->sendPasswordResetEmail($to, $name, $resetLink);
        }
    }
    
    if (!function_exists('sendDepositConfirmationEmail')) {
        function sendDepositConfirmationEmail($to, $name, $amount, $method, $transactionId) {
            global $mailSystem;
            return $mailSystem->sendDepositConfirmationEmail($to, $name, $amount, $method, $transactionId);
        }
    }
    
    if (!function_exists('sendWithdrawalConfirmationEmail')) {
        function sendWithdrawalConfirmationEmail($to, $name, $amount, $method, $transactionId) {
            global $mailSystem;
            return $mailSystem->sendWithdrawalConfirmationEmail($to, $name, $amount, $method, $transactionId);
        }
    }
    
    if (!function_exists('sendKYCApprovalEmail')) {
        function sendKYCApprovalEmail($to, $name) {
            global $mailSystem;
            return $mailSystem->sendKYCApprovalEmail($to, $name);
        }
    }
    
    if (!function_exists('sendKYCRejectionEmail')) {
        function sendKYCRejectionEmail($to, $name, $reason) {
            global $mailSystem;
            return $mailSystem->sendKYCRejectionEmail($to, $name, $reason);
        }
    }
    
    if (!function_exists('sendAccountVerificationEmail')) {
        function sendAccountVerificationEmail($to, $name, $verificationLink) {
            global $mailSystem;
            return $mailSystem->sendAccountVerificationEmail($to, $name, $verificationLink);
        }
    }
    
    if (!function_exists('sendTradingAccountCreatedEmail')) {
        function sendTradingAccountCreatedEmail($to, $name, $accountNumber, $accountType, $leverage) {
            global $mailSystem;
            return $mailSystem->sendTradingAccountCreatedEmail($to, $name, $accountNumber, $accountType, $leverage);
        }
    }
    
} else {
    // Mail system not available - log warning
    error_log("⚠️ Mail system not found at: " . __DIR__ . '/mail_system/integrated_mail_system.php');
}

// ================================
// CORS HEADERS
// ================================
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

?>
